class Enemy_Cyborg expands Enemy;

#exec MESH IMPORT MESH=Cyborg ANIVFILE=Models\Enemies\Cyborg\Cyborg_a.3d DATAFILE=Models\Enemies\Cyborg\Cyborg_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Cyborg X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=Cyborg SEQ=All      STARTFRAME=0 NUMFRAMES=290    RATE=14
#exec MESH SEQUENCE MESH=Cyborg SEQ=attack1  STARTFRAME=0 NUMFRAMES=12    RATE=14
#exec MESH SEQUENCE MESH=Cyborg SEQ=attack2  STARTFRAME=12 NUMFRAMES=12    RATE=14
#exec MESH SEQUENCE MESH=Cyborg SEQ=attack3  STARTFRAME=24 NUMFRAMES=40    RATE=16
#exec MESH SEQUENCE MESH=Cyborg SEQ=attack4  STARTFRAME=64 NUMFRAMES=12    RATE=18
#exec MESH SEQUENCE MESH=Cyborg SEQ=attack5  STARTFRAME=76 NUMFRAMES=12    RATE=18
#exec MESH SEQUENCE MESH=Cyborg SEQ=attack6  STARTFRAME=88 NUMFRAMES=17    RATE=20
#exec MESH SEQUENCE MESH=Cyborg SEQ=breathe1 STARTFRAME=105 NUMFRAMES=16  RATE=6
#exec MESH SEQUENCE MESH=Cyborg SEQ=death1   STARTFRAME=121 NUMFRAMES=19  RATE=16
#exec MESH SEQUENCE MESH=Cyborg SEQ=death2   STARTFRAME=140 NUMFRAMES=25  RATE=16
#exec MESH SEQUENCE MESH=Cyborg SEQ=hit1     STARTFRAME=165 NUMFRAMES=1    
#exec MESH SEQUENCE MESH=Cyborg SEQ=hit2     STARTFRAME=166 NUMFRAMES=1    
#exec MESH SEQUENCE MESH=Cyborg SEQ=hit3     STARTFRAME=167 NUMFRAMES=1    
#exec MESH SEQUENCE MESH=Cyborg SEQ=hit4     STARTFRAME=168 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Cyborg SEQ=land     STARTFRAME=169 NUMFRAMES=20    
#exec MESH SEQUENCE MESH=Cyborg SEQ=look1    STARTFRAME=189 NUMFRAMES=48  RATE=8
#exec MESH SEQUENCE MESH=Cyborg SEQ=look2    STARTFRAME=237 NUMFRAMES=41  RATE=8
#exec MESH SEQUENCE MESH=Cyborg SEQ=run      STARTFRAME=278 NUMFRAMES=16  RATE=20
#exec MESH SEQUENCE MESH=Cyborg SEQ=walk     STARTFRAME=294 NUMFRAMES=16  RATE=20

#exec TEXTURE IMPORT NAME=JCyborg0 FILE=Textures\Enemies\Cyborg\JCyborg0.bmp GROUP=Skins FLAGS=2 // skin
                                       
#exec MESHMAP NEW   MESHMAP=Cyborg MESH=Cyborg
#exec MESHMAP SCALE MESHMAP=Cyborg X=0.1 Y=0.1 Z=0.2

#exec MESHMAP SETTEXTURE MESHMAP=Cyborg NUM=0 TEXTURE=JCyborg0

#exec MESH NOTIFY MESH=Cyborg SEQ=attack1 TIME=0.20 FUNCTION=MeleeAttackDamageNormal
#exec MESH NOTIFY MESH=Cyborg SEQ=attack1 TIME=0.60 FUNCTION=MeleeAttackDamageNormal
#exec MESH NOTIFY MESH=Cyborg SEQ=attack2 TIME=0.20 FUNCTION=MeleeAttackDamageNormal
#exec MESH NOTIFY MESH=Cyborg SEQ=attack3 TIME=0.45 FUNCTION=MeleeAttackDamageHuge
#exec MESH NOTIFY MESH=Cyborg SEQ=attack4 TIME=0.45 FUNCTION=RangedAttackDamage
#exec MESH NOTIFY MESH=Cyborg SEQ=attack5 TIME=0.25 FUNCTION=RangedAttackDamage
#exec MESH NOTIFY MESH=Cyborg SEQ=attack5 TIME=0.45 FUNCTION=RangedAttackDamage
#exec MESH NOTIFY MESH=Cyborg SEQ=attack6 TIME=0.25 FUNCTION=RangedAttackDamage
#exec MESH NOTIFY MESH=Cyborg SEQ=walk TIME=0.35 FUNCTION=WalkStep
#exec MESH NOTIFY MESH=Cyborg SEQ=walk TIME=0.95 FUNCTION=WalkStep
#exec MESH NOTIFY MESH=Cyborg SEQ=run TIME=0.35 FUNCTION=WalkStep
#exec MESH NOTIFY MESH=Cyborg SEQ=run TIME=0.95 FUNCTION=WalkStep
#exec MESH NOTIFY MESH=Cyborg SEQ=attack1 TIME=0.15 FUNCTION=PunchSound
#exec MESH NOTIFY MESH=Cyborg SEQ=attack1 TIME=0.55 FUNCTION=PunchSound
#exec MESH NOTIFY MESH=Cyborg SEQ=attack2 TIME=0.15 FUNCTION=PunchSound
#exec MESH NOTIFY MESH=Cyborg SEQ=attack3 TIME=0.35 FUNCTION=SwingSound


var() float MeleeDamage;

var(CyborgSounds) sound punch;
var(CyborgSounds) sound swing;
var(CyborgSounds) sound die;
var(CyborgSounds) sound footstep;
var(CyborgSounds) sound breathe;

function TakeDamage( int Damage, Pawn ins, Vector hitloc,  //UsAaR33: let damage be handled by damage type
            Vector m, name damageType)
{
//damage type adjustmants:
if (damagetype=='jolted'||damagetype=='decapitated'){
damage*=2;
if (frand()>0.5){ //lose some intelligence (EMP)
if (skill>1)
skill-=1;
else if (intelligence>BRAINS_REPTILE) {
if (intelligence==brains_human) intelligence=brains_mammal;
else intelligence=brains_reptile;}
}}
else if (damagetype=='shot')
damage/=1.7;
else if (damagetype=='zapped')
damage*=1.2;
else if (damagetype=='shredded')
damage/=3;
else if (damagetype=='burned')
damage/=2.7;
super.takedamage(damage,ins,hitloc,m,damagetype);
}
function eAttitude AttitudeToCreature(Pawn Other)
{
  if ( Other.IsA('Cyborg')||other.isa('cyberus') )
    return ATTITUDE_Friendly;
  else
    return ATTITUDE_Ignore;
}

function WalkStep()
{
  PlaySound(footstep, ,10.0,,7500);
}

function SwingSound()
{
  PlaySound(swing, SLOT_Interact,10.0,,7500);
}
function PunchSound()
{
  PlaySound(punch, SLOT_Interact,10.0,,7500);
}

function PlayWaiting()
{
  local float decision;

  decision = FRand();

  if (decision < 0.5)
    PlayAnim('look1');
  else 
    PlayAnim('look2');

  PlaySound(breathe, SLOT_Interact,1.0,,500);
}
  
function PlayPatrolStop()
{
  PlayWaiting();
}

function PlayWaitingAmbush()
{
  PlayWaiting();
}

function PlayChallenge()
{
  PlayWaiting();
}

function TweenToFighter(float tweentime)
{
  TweenAnim('attack1', tweentime);
}

function TweenToRunning(float tweentime)
{
  TweenAnim('run', tweentime);
}

function TweenToWalking(float tweentime)
{
  TweenAnim('walk', tweentime);
}

function TweenToWaiting(float tweentime)
{
  TweenAnim('look1', tweentime);
}

function TweenToPatrolStop(float tweentime)
{
  TweenToWaiting(tweentime);
}

function PlayRunning()
{
  LoopAnim('run', -1.0/GroundSpeed,, 0.8);
}

function PlayWalking()
{
  LoopAnim('walk', -1.0/GroundSpeed,, 0.8);
}

function PlayTurning()
{
  LoopAnim('walk',, 0.15);
}

function PlayDying(name DamageType, vector HitLocation)
{
  if (FRand() < 0.5)
    PlayAnim('Death2', 0.7, 0.15);
  else
    PlayAnim('Death1', 0.7, 0.15);
    
  PlaySound(die, SLOT_Interact,1.0,,500);
}

function PlayTakeHit(float tweentime, vector HitLoc, int Damage)
{
  local actor A;
  local float Decision;

  Decision = FRand();

    
  if (Decision < 0.25)
  {
    tweenAnim('hit1', tweentime);
  } else if (Decision < 0.5) {
    tweenAnim('hit2', tweentime);
  } else if (Decision < 0.75) {
    tweenAnim('hit3', tweentime);
  } else {
    tweenAnim('hit4', tweentime);
  }
}

function PlayVictoryDance()
{
  PlayWaiting();
}

function bool CanFireAtEnemy()
{
  local vector HitLocation, HitNormal,X,Y,Z, projStart, EnemyDir, EnemyUp;
  local actor HitActor1, HitActor2;
  local float EnemyDist;
    
  EnemyDir = Enemy.Location - Location;
  EnemyDist = VSize(EnemyDir);
  EnemyUp = Enemy.CollisionHeight * vect(0,0,0.9);
  if ( EnemyDist > 300 )
  {
    EnemyDir = 300 * EnemyDir/EnemyDist;
    EnemyUp = 300 * EnemyUp/EnemyDist;
  }

  GetAxes(Rotation,X,Y,Z);
  projStart = Location + 0.5 * CollisionRadius * X + 0.8 * CollisionRadius * Y + 0.4 * CollisionRadius * Z;
  HitActor1 = Trace(HitLocation, HitNormal, projStart + EnemyDir + EnemyUp, projStart, true);
  if ( (HitActor1 != Enemy) && (Pawn(HitActor1) != None) 
    && (AttitudeTo(Pawn(HitActor1)) > ATTITUDE_Ignore) )
    return false;
     
  projStart = Location + 0.5 * CollisionRadius * X - 0.8 * CollisionRadius * Y + 0.4 * CollisionRadius * Z;
  HitActor2 = Trace(HitLocation, HitNormal, projStart + EnemyDir + EnemyUp, projStart, true);

  if ( (HitActor2 == None) || (HitActor2 == Enemy) 
    || ((Pawn(HitActor2) != None) && (AttitudeTo(Pawn(HitActor2)) <= ATTITUDE_Ignore)) )
    return true;

  HitActor2 = Trace(HitLocation, HitNormal, projStart + EnemyDir, projStart , true);

  return ( (HitActor2 == None) || (HitActor2 == Enemy) 
      || ((Pawn(HitActor2) != None) && (AttitudeTo(Pawn(HitActor2)) <= ATTITUDE_Ignore)) );
}

function PlayMovingAttack()
{
  LoopAnim('attack6');
}

function PlayMeleeAttack()
{
  if (Frand() < 0.3) {
    PlayAnim('attack1');
  } else if (FRand() < 0.66) {
    PlayAnim('attack2');
  } else {
    PlayAnim('attack3');
  }
}

function PlayRangedAttack()
{
  if (FRand() < 0.3)
  {
    PlayAnim('Attack5');
  }
  else
  {
    PlayAnim('Attack4');
  }
}

function MeleeAttackDamageNormal()
{
  MeleeDamageTarget(MeleeDamage, (70.0 * (Normal(Target.Location - Location))));
}

function MeleeAttackDamageHuge()
{
  MeleeDamageTarget(MeleeDamage * 4, (70.0 * (Normal(Target.Location - Location))));  
}

function RangedAttackDamage()
{
  FireProjectile( vect(1.5,1.5,0), 0);
}  

defaultproperties
{
    HUDname="Cyborg"
	HUDcolor=(R=255,G=0,B=0)
    MeleeDamage=10.00
    Punch=Sound'boss2'
    Swing=Sound'wipe'
    Die=Sound'BossHit3'
    footstep=Sound'UnrealShare.Brute.walk2br'
    Breathe=Sound'BossBreath'
    CarcassType=Class'UnrealI.MercCarcass'
    TimeBetweenAttacks=0.20
    Aggressiveness=50.00
    bHasRangedAttack=True
    bMovingRangedAttack=True
    bWarnTarget=False
    bGreenBlood=True
    RangedProjectile=Class'UnrealI.EliteKrallBolt'
    Acquire=Sound'weirdbleep'
    Fear=Sound'boss2'
    Roam=Sound'mekturn'
    Threaten=Sound'boss5'
    MeleeRange=35.00
    GroundSpeed=300.00
    AccelRate=240.00
    HearingThreshold=0.70
    Health=400
    Intelligence=3
    Skill=5.00
    HitSound1=Sound'mekturn'
    HitSound2=Sound'mekturn'
    CombatStyle=20.00
    AmbientSound=Sound'ambmodern.Looping.machine2'
    DrawType=2
    Mesh=LodMesh'cyborg'
    CollisionHeight=50.00
    RotationRate=(Pitch=4096,Yaw=50000,Roll=1700),
}
